<?php
/**
 * GateCloud - Giriş Sayfası
 * Şirket kodu ile giriş
 */

require_once __DIR__ . '/config/config.php';
require_once __DIR__ . '/includes/Auth.php';

Auth::init();

// Zaten giriş yapılmışsa dashboard'a yönlendir
if (Auth::check()) {
    header('Location: /dashboard.php');
    exit;
}

$error = '';
$success = '';

// Form gönderildi mi?
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $companyCode = trim($_POST['company_code'] ?? '');
    $username = trim($_POST['username'] ?? '');
    $password = $_POST['password'] ?? '';
    $remember = isset($_POST['remember']);
    
    if (empty($companyCode) || empty($username) || empty($password)) {
        $error = 'Tüm alanları doldurun.';
    } else {
        $result = Auth::loginWithCompanyCode($companyCode, $username, $password, $remember);
        
        if ($result['success']) {
            header('Location: /dashboard.php');
            exit;
        } else {
            $error = $result['message'];
        }
    }
}
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Giriş - <?= APP_NAME ?></title>
    <link href="https://cdn.jsdelivr.net/npm/tailwindcss@2.2.19/dist/tailwind.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
    <style>
        .gradient-bg {
            background: linear-gradient(135deg, #1e3a5f 0%, #2d5a87 50%, #1e3a5f 100%);
        }
        .glass-card {
            background: rgba(255, 255, 255, 0.95);
            backdrop-filter: blur(10px);
        }
        .input-focus:focus {
            border-color: #2d5a87;
            box-shadow: 0 0 0 3px rgba(45, 90, 135, 0.1);
        }
    </style>
</head>
<body class="gradient-bg min-h-screen flex items-center justify-center p-4">
    <div class="w-full max-w-md">
        <!-- Logo -->
        <div class="text-center mb-8">
            <div class="inline-flex items-center justify-center w-20 h-20 bg-white rounded-2xl shadow-lg mb-4">
                <i class="fas fa-door-open text-4xl text-blue-600"></i>
            </div>
            <h1 class="text-3xl font-bold text-white"><?= APP_NAME ?></h1>
            <p class="text-blue-200 mt-2">Geçiş Kontrol Sistemi</p>
        </div>
        
        <!-- Login Card -->
        <div class="glass-card rounded-2xl shadow-2xl p-8">
            <h2 class="text-2xl font-semibold text-gray-800 mb-6 text-center">Giriş Yap</h2>
            
            <?php if ($error): ?>
            <div class="bg-red-50 border border-red-200 text-red-700 px-4 py-3 rounded-lg mb-6 flex items-center">
                <i class="fas fa-exclamation-circle mr-2"></i>
                <?= e($error) ?>
            </div>
            <?php endif; ?>
            
            <form method="POST" action="" class="space-y-5">
                <!-- Şirket Kodu -->
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-2">
                        <i class="fas fa-building mr-1"></i> Şirket Kodu
                    </label>
                    <input type="text" name="company_code" 
                           value="<?= e($_POST['company_code'] ?? '') ?>"
                           class="w-full px-4 py-3 border border-gray-300 rounded-lg input-focus transition-all"
                           placeholder="örn: DEMO"
                           required autofocus>
                </div>
                
                <!-- Kullanıcı Adı -->
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-2">
                        <i class="fas fa-user mr-1"></i> Kullanıcı Adı
                    </label>
                    <input type="text" name="username"
                           value="<?= e($_POST['username'] ?? '') ?>"
                           class="w-full px-4 py-3 border border-gray-300 rounded-lg input-focus transition-all"
                           placeholder="Kullanıcı adınız"
                           required>
                </div>
                
                <!-- Şifre -->
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-2">
                        <i class="fas fa-lock mr-1"></i> Şifre
                    </label>
                    <div class="relative">
                        <input type="password" name="password" id="password"
                               class="w-full px-4 py-3 border border-gray-300 rounded-lg input-focus transition-all pr-12"
                               placeholder="••••••••"
                               required>
                        <button type="button" onclick="togglePassword()" 
                                class="absolute right-3 top-1/2 transform -translate-y-1/2 text-gray-500 hover:text-gray-700">
                            <i class="fas fa-eye" id="toggleIcon"></i>
                        </button>
                    </div>
                </div>
                
                <!-- Beni Hatırla -->
                <div class="flex items-center justify-between">
                    <label class="flex items-center">
                        <input type="checkbox" name="remember" class="w-4 h-4 text-blue-600 rounded">
                        <span class="ml-2 text-sm text-gray-600">Beni hatırla</span>
                    </label>
                    <a href="/forgot-password.php" class="text-sm text-blue-600 hover:underline">
                        Şifremi unuttum
                    </a>
                </div>
                
                <!-- Giriş Butonu -->
                <button type="submit" 
                        class="w-full bg-blue-600 text-white py-3 px-4 rounded-lg font-medium 
                               hover:bg-blue-700 transition-colors flex items-center justify-center">
                    <i class="fas fa-sign-in-alt mr-2"></i>
                    Giriş Yap
                </button>
            </form>
            
            <!-- Demo Bilgisi -->
            <div class="mt-6 p-4 bg-blue-50 rounded-lg">
                <p class="text-sm text-blue-800 font-medium mb-2">
                    <i class="fas fa-info-circle mr-1"></i> Demo Hesabı
                </p>
                <p class="text-xs text-blue-600">
                    Şirket Kodu: <strong>DEMO</strong><br>
                    Kullanıcı: <strong>admin</strong><br>
                    Şifre: <strong>demo123</strong>
                </p>
            </div>
        </div>
        
        <!-- Footer -->
        <div class="text-center mt-6 text-blue-200 text-sm">
            <p>&copy; <?= date('Y') ?> <?= APP_NAME ?>. Tüm hakları saklıdır.</p>
            <p class="mt-1">v<?= APP_VERSION ?></p>
        </div>
    </div>
    
    <script>
        function togglePassword() {
            const input = document.getElementById('password');
            const icon = document.getElementById('toggleIcon');
            
            if (input.type === 'password') {
                input.type = 'text';
                icon.classList.remove('fa-eye');
                icon.classList.add('fa-eye-slash');
            } else {
                input.type = 'password';
                icon.classList.remove('fa-eye-slash');
                icon.classList.add('fa-eye');
            }
        }
    </script>
</body>
</html>
