<?php
/**
 * GateCloud - Layout Header
 */

if (!defined('PAGE_TITLE')) {
    define('PAGE_TITLE', 'Dashboard');
}

$currentPage = basename($_SERVER['PHP_SELF'], '.php');
$admin = Auth::user();
$company = Auth::company();
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= PAGE_TITLE ?> - <?= APP_NAME ?></title>
    <link href="https://cdn.jsdelivr.net/npm/tailwindcss@2.2.19/dist/tailwind.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/alpinejs@3.x.x/dist/cdn.min.js" defer></script>
    <style>
        .sidebar { width: 260px; }
        .main-content { margin-left: 260px; }
        @media (max-width: 1024px) {
            .sidebar { transform: translateX(-100%); }
            .sidebar.open { transform: translateX(0); }
            .main-content { margin-left: 0; }
        }
        .nav-item.active { background: rgba(59, 130, 246, 0.1); border-right: 3px solid #3B82F6; }
        .nav-item:hover { background: rgba(59, 130, 246, 0.05); }
        .card { background: white; border-radius: 12px; box-shadow: 0 1px 3px rgba(0,0,0,0.1); }
        .badge { padding: 2px 8px; border-radius: 9999px; font-size: 12px; font-weight: 500; }
        .badge-success { background: #DEF7EC; color: #03543F; }
        .badge-warning { background: #FEF3C7; color: #92400E; }
        .badge-danger { background: #FDE8E8; color: #9B1C1C; }
        .badge-info { background: #E1EFFE; color: #1E40AF; }
    </style>
    <?php if (isset($extraHead)) echo $extraHead; ?>
</head>
<body class="bg-gray-50" x-data="{ sidebarOpen: false, userMenuOpen: false, notificationOpen: false }">
    
    <!-- Mobile Overlay -->
    <div x-show="sidebarOpen" @click="sidebarOpen = false" 
         class="fixed inset-0 bg-black bg-opacity-50 z-40 lg:hidden"></div>
    
    <!-- Sidebar -->
    <aside class="sidebar fixed top-0 left-0 h-full bg-white border-r border-gray-200 z-50 transition-transform lg:translate-x-0"
           :class="{ 'open': sidebarOpen }">
        
        <!-- Logo -->
        <div class="h-16 flex items-center px-6 border-b border-gray-200">
            <i class="fas fa-door-open text-2xl text-blue-600 mr-3"></i>
            <span class="text-xl font-bold text-gray-800"><?= APP_NAME ?></span>
        </div>
        
        <!-- Company Info -->
        <div class="px-4 py-3 bg-gray-50 border-b">
            <p class="text-xs text-gray-500">Şirket</p>
            <p class="font-medium text-gray-800 truncate"><?= e($company['name']) ?></p>
            <span class="badge badge-info mt-1"><?= e($admin['package_name']) ?></span>
        </div>
        
        <!-- Navigation -->
        <nav class="p-4 space-y-1">
            <a href="/dashboard.php" class="nav-item flex items-center px-4 py-3 rounded-lg text-gray-700 <?= $currentPage == 'dashboard' ? 'active' : '' ?>">
                <i class="fas fa-home w-5 mr-3"></i> Dashboard
            </a>
            
            <p class="text-xs font-semibold text-gray-400 uppercase mt-4 mb-2 px-4">Geçiş Kontrol</p>
            
            <a href="/devices.php" class="nav-item flex items-center px-4 py-3 rounded-lg text-gray-700 <?= $currentPage == 'devices' ? 'active' : '' ?>">
                <i class="fas fa-server w-5 mr-3"></i> Cihazlar
            </a>
            <a href="/users.php" class="nav-item flex items-center px-4 py-3 rounded-lg text-gray-700 <?= $currentPage == 'users' ? 'active' : '' ?>">
                <i class="fas fa-users w-5 mr-3"></i> Personel
            </a>
            <a href="/cards.php" class="nav-item flex items-center px-4 py-3 rounded-lg text-gray-700 <?= $currentPage == 'cards' ? 'active' : '' ?>">
                <i class="fas fa-id-card w-5 mr-3"></i> Kartlar
            </a>
            <a href="/access-logs.php" class="nav-item flex items-center px-4 py-3 rounded-lg text-gray-700 <?= $currentPage == 'access-logs' ? 'active' : '' ?>">
                <i class="fas fa-clipboard-list w-5 mr-3"></i> Geçiş Logları
            </a>
            <a href="/visitors.php" class="nav-item flex items-center px-4 py-3 rounded-lg text-gray-700 <?= $currentPage == 'visitors' ? 'active' : '' ?>">
                <i class="fas fa-user-clock w-5 mr-3"></i> Ziyaretçiler
            </a>
            
            <p class="text-xs font-semibold text-gray-400 uppercase mt-4 mb-2 px-4">Raporlar</p>
            
            <a href="/reports/daily.php" class="nav-item flex items-center px-4 py-3 rounded-lg text-gray-700">
                <i class="fas fa-chart-bar w-5 mr-3"></i> Günlük Rapor
            </a>
            <a href="/reports/monthly.php" class="nav-item flex items-center px-4 py-3 rounded-lg text-gray-700">
                <i class="fas fa-chart-line w-5 mr-3"></i> Aylık Rapor
            </a>
            
            <?php if (Auth::hasRole(['owner', 'admin'])): ?>
            <p class="text-xs font-semibold text-gray-400 uppercase mt-4 mb-2 px-4">Yönetim</p>
            
            <a href="/departments.php" class="nav-item flex items-center px-4 py-3 rounded-lg text-gray-700 <?= $currentPage == 'departments' ? 'active' : '' ?>">
                <i class="fas fa-sitemap w-5 mr-3"></i> Departmanlar
            </a>
            <a href="/admins.php" class="nav-item flex items-center px-4 py-3 rounded-lg text-gray-700 <?= $currentPage == 'admins' ? 'active' : '' ?>">
                <i class="fas fa-user-shield w-5 mr-3"></i> Yöneticiler
            </a>
            <a href="/settings.php" class="nav-item flex items-center px-4 py-3 rounded-lg text-gray-700 <?= $currentPage == 'settings' ? 'active' : '' ?>">
                <i class="fas fa-cog w-5 mr-3"></i> Ayarlar
            </a>
            <?php endif; ?>
        </nav>
        
        <!-- PDKS Link -->
        <div class="absolute bottom-0 left-0 right-0 p-4 border-t bg-gray-50">
            <a href="<?= PDKSCLOUD_API_URL ?>/../" target="_blank" 
               class="flex items-center justify-center px-4 py-2 bg-green-600 text-white rounded-lg hover:bg-green-700 transition">
                <i class="fas fa-calendar-check mr-2"></i> PdksCloud'a Git
            </a>
        </div>
    </aside>
    
    <!-- Main Content -->
    <div class="main-content min-h-screen">
        <!-- Top Header -->
        <header class="h-16 bg-white border-b border-gray-200 flex items-center justify-between px-6 sticky top-0 z-30">
            <!-- Mobile Menu Button -->
            <button @click="sidebarOpen = !sidebarOpen" class="lg:hidden text-gray-600">
                <i class="fas fa-bars text-xl"></i>
            </button>
            
            <!-- Page Title -->
            <h1 class="text-xl font-semibold text-gray-800 hidden sm:block"><?= PAGE_TITLE ?></h1>
            
            <!-- Right Side -->
            <div class="flex items-center space-x-4">
                <!-- Notifications -->
                <div class="relative" x-data="{ open: false }">
                    <button @click="open = !open" class="relative p-2 text-gray-600 hover:bg-gray-100 rounded-lg">
                        <i class="fas fa-bell text-xl"></i>
                        <span class="absolute top-1 right-1 w-2 h-2 bg-red-500 rounded-full"></span>
                    </button>
                    
                    <div x-show="open" @click.away="open = false" 
                         class="absolute right-0 mt-2 w-80 bg-white rounded-lg shadow-lg border py-2 z-50">
                        <div class="px-4 py-2 border-b">
                            <h3 class="font-semibold">Bildirimler</h3>
                        </div>
                        <div class="max-h-64 overflow-y-auto">
                            <a href="#" class="block px-4 py-3 hover:bg-gray-50 border-b">
                                <p class="text-sm text-gray-800">Yeni cihaz eklendi</p>
                                <p class="text-xs text-gray-500">2 dakika önce</p>
                            </a>
                        </div>
                        <a href="/notifications.php" class="block text-center text-sm text-blue-600 py-2 hover:bg-gray-50">
                            Tümünü Gör
                        </a>
                    </div>
                </div>
                
                <!-- User Menu -->
                <div class="relative" x-data="{ open: false }">
                    <button @click="open = !open" class="flex items-center space-x-3 hover:bg-gray-100 rounded-lg p-2">
                        <div class="w-8 h-8 bg-blue-600 rounded-full flex items-center justify-center">
                            <span class="text-white font-medium text-sm">
                                <?= strtoupper(substr($admin['name'], 0, 1)) ?>
                            </span>
                        </div>
                        <span class="hidden sm:block text-sm font-medium text-gray-700"><?= e($admin['name']) ?></span>
                        <i class="fas fa-chevron-down text-xs text-gray-500"></i>
                    </button>
                    
                    <div x-show="open" @click.away="open = false"
                         class="absolute right-0 mt-2 w-48 bg-white rounded-lg shadow-lg border py-2 z-50">
                        <a href="/profile.php" class="block px-4 py-2 text-gray-700 hover:bg-gray-50">
                            <i class="fas fa-user mr-2"></i> Profilim
                        </a>
                        <a href="/settings.php" class="block px-4 py-2 text-gray-700 hover:bg-gray-50">
                            <i class="fas fa-cog mr-2"></i> Ayarlar
                        </a>
                        <hr class="my-2">
                        <a href="/logout.php" class="block px-4 py-2 text-red-600 hover:bg-gray-50">
                            <i class="fas fa-sign-out-alt mr-2"></i> Çıkış Yap
                        </a>
                    </div>
                </div>
            </div>
        </header>
        
        <!-- Page Content -->
        <main class="p-6">
