        </main>
        
        <!-- Footer -->
        <footer class="px-6 py-4 border-t bg-white text-center text-sm text-gray-500">
            &copy; <?= date('Y') ?> <?= APP_NAME ?> v<?= APP_VERSION ?>
        </footer>
    </div>
    
    <!-- Toast Notifications -->
    <div id="toast-container" class="fixed bottom-4 right-4 z-50 space-y-2"></div>
    
    <script>
        // Toast notification
        function showToast(message, type = 'success') {
            const container = document.getElementById('toast-container');
            const toast = document.createElement('div');
            
            const colors = {
                success: 'bg-green-500',
                error: 'bg-red-500',
                warning: 'bg-yellow-500',
                info: 'bg-blue-500'
            };
            
            const icons = {
                success: 'fa-check-circle',
                error: 'fa-times-circle',
                warning: 'fa-exclamation-circle',
                info: 'fa-info-circle'
            };
            
            toast.className = `${colors[type]} text-white px-6 py-3 rounded-lg shadow-lg flex items-center transform transition-all duration-300 translate-x-full`;
            toast.innerHTML = `<i class="fas ${icons[type]} mr-2"></i> ${message}`;
            
            container.appendChild(toast);
            
            setTimeout(() => toast.classList.remove('translate-x-full'), 10);
            setTimeout(() => {
                toast.classList.add('translate-x-full');
                setTimeout(() => toast.remove(), 300);
            }, 3000);
        }
        
        // Confirm dialog
        function confirmAction(message, callback) {
            if (confirm(message)) {
                callback();
            }
        }
        
        // Format number
        function formatNumber(num) {
            return new Intl.NumberFormat('tr-TR').format(num);
        }
        
        // Format date
        function formatDate(date) {
            return new Date(date).toLocaleDateString('tr-TR');
        }
        
        // Format datetime
        function formatDateTime(date) {
            return new Date(date).toLocaleString('tr-TR');
        }
        
        // AJAX helper
        async function apiRequest(url, method = 'GET', data = null) {
            const options = {
                method,
                headers: {
                    'Content-Type': 'application/json',
                    'X-Requested-With': 'XMLHttpRequest'
                }
            };
            
            if (data) {
                options.body = JSON.stringify(data);
            }
            
            try {
                const response = await fetch(url, options);
                const result = await response.json();
                
                if (!response.ok) {
                    throw new Error(result.message || 'Bir hata oluştu');
                }
                
                return result;
            } catch (error) {
                showToast(error.message, 'error');
                throw error;
            }
        }
        
        // DataTable initialize
        function initDataTable(selector, options = {}) {
            // Basit tablo sıralama ve filtreleme
            const table = document.querySelector(selector);
            if (!table) return;
            
            const headers = table.querySelectorAll('th[data-sortable]');
            headers.forEach(header => {
                header.style.cursor = 'pointer';
                header.addEventListener('click', () => {
                    sortTable(table, header.cellIndex);
                });
            });
        }
        
        function sortTable(table, column) {
            const tbody = table.querySelector('tbody');
            const rows = Array.from(tbody.querySelectorAll('tr'));
            
            rows.sort((a, b) => {
                const aVal = a.cells[column].textContent.trim();
                const bVal = b.cells[column].textContent.trim();
                return aVal.localeCompare(bVal, 'tr');
            });
            
            rows.forEach(row => tbody.appendChild(row));
        }
    </script>
    
    <?php if (isset($extraScripts)) echo $extraScripts; ?>
</body>
</html>
